unit Print_Ma;

INTERFACE

procedure DevelopGraph(rotate :boolean);

IMPLEMENTATION

uses graph;

const
  rotate90  = true;
  widepaper = false;
  maxx      = 640;
  maxy      = 480;

procedure developgraph(rotate: boolean);

const maxprinter = 816;

var
  graphwidth,graphheight,printerwidth,printerheight: integer;
  n1,n2,sx,sy,x,y,y2,pixcolr: integer;
  widthratio,heightratio: real;
  blank: boolean;
  bitloc,bits: byte;
  bytes: array [1..maxprinter] of byte;
  lst: text;

begin
  assign(lst,'lpt1');
  rewrite(lst);
  case rotate of
    widepaper:begin
                graphwidth:= maxx;
                graphheight:= maxy;
                printerwidth:= maxprinter;
                printerheight:= graphheight*1;
              end;
     rotate90:begin
                graphwidth:= getmaxy+1;
                graphheight:= getmaxx+1;
                printerwidth:= graphwidth;
                printerheight:= graphheight;
              end;
  end;
  n2:= printerwidth div 256;
  n1:= printerwidth mod 256;
  write (lst,chr(27),'A',chr(8));
  widthratio:= printerwidth/graphwidth;
  heightratio:= printerheight/graphheight;
  y:= 0;
  while y < printerheight do begin
    blank:= true;
    for x:= 1 to printerwidth do begin
      sx:= trunc ((x-1)/widthratio);
      bits:= 0;
      bitloc:= $80;
      for y2:= y to y+7 do begin
        sy:= trunc(y2/heightratio);
        if sy < graphheight then begin
          case rotate of
            widepaper: pixcolr:= getpixel (sx,sy);
            rotate90 : pixcolr:= getpixel (sy,sx);
          end;
          if pixcolr in[1..7,9..15] then bits:= bits or bitloc;
              { alle kleuren behalve 0=zwart en 8=donkergrijs }
        end;
        bitloc:= bitloc shr 1;
      end;
      case rotate of
        widepaper: bytes [x]:= bits;
        rotate90 : bytes [printerwidth-x+1]:= bits;
      end;
      if bits > 0 then blank:= false;
    end;
    if not blank then begin
      write (lst,chr(27),'K',chr(n1),chr(n2));
      for x:= 1 to printerwidth do write (lst,chr(bytes[x]));
    end;
    writeln (lst);
    y:= y+8;
  end;
  write (lst,chr(12));
  write (lst,chr(27),'@');
  close(lst);
end;

begin
end.
