/************************************/
/* Druhy projekt z GPG              */
/* Program pro kresleni elipsoidu   */
/* Autor: Martin KOSTURIK     @1998 */
/************************************/

#include <stdio.h>
#include <graphics.h>
#include <conio.h>
#include <math.h>

int mx, my, mx_2, my_2;
const double q = sqrt(2) / 2;

void ramecek(void);
int input(char *zprava, double min, double max);
void transformace(int x, int y, int z, int barva);


void main(void)
{
	int d;
	double	x, y, z, A, B, C, fi, theta, n_rovn, n_poled;

	int graph_driver = DETECT, graph_mode = VGAHI, grchyba;

	grchyba = registerbgidriver(EGAVGA_driver);
	if(grchyba < 0) {
		printf("\nChyba grafiky: %s", grapherrormsg(grchyba));
		return;
	}
	initgraph(&graph_driver,&graph_mode, "");

	mx = getmaxx();
	my = getmaxy();
	mx_2 = mx / 2;
	my_2 = my / 2;

	while(1) {

		ramecek();
		gotoxy(29, 2);
		printf("Druhy projekt z GPG.");
		gotoxy(14,3);
		printf("Program pro vykresleni drateneho modelu elipsoidu.");
		gotoxy(28,4);
		printf("Martin KOSTURIK  @1998");
		gotoxy(34, 13);
		printf("1 ... START");
		gotoxy(34, 14);
		printf("0 ... KONEC");

		while(1) {
			gotoxy(34, 16);
			printf("Co vyberes?");
			d = getch();
			if(d == '0' || d == '1') break;
		}
		if(d == '0') break;

		A = input("Zadej parametr A ? (10 - 200) : ", 10.0, 200.0);
		B = input("Zadej parametr B ? (10 - 300) : ", 10.0, 300.0);
		C = input("Zadej parametr C ? (10 - 200) : ", 10.0, 200.0);
		n_rovn = input("Kolik rovnobezek ? (10 - 100) : ", 10.0, 100.0);
		n_poled = input("Kolik poledniku ? (10 - 100) : ", 10.0, 100.0);

		ramecek();

		for(theta = -M_PI_2; theta <= M_PI_2; theta += (M_PI / 1000)) {
			for(fi = 0.0; fi <= (2.0 * M_PI); fi += (M_PI / n_rovn)) {
				x = A * cos(theta) * cos(fi);
				y = B * sin(theta) * cos(fi);
				z = C * sin(fi);
				transformace(x, y, z, YELLOW);
			}
		}
		for(fi = 0.0; fi <= (2.0 * M_PI); fi += (M_PI / n_poled)) {
			for(theta = -M_PI_2; theta <= M_PI_2; theta += (M_PI / 1000)) {
				x = A * cos(fi) * cos(theta);
				y = B * sin(fi) * cos(theta);
				z = C * sin(theta);
				transformace(x, y, z, GREEN);
			}
		}
		getch();
	}

	cleardevice();
	closegraph();

return;
}


int input(char *zprava, double min, double max)
{
  double hodnota;

  while(1) {
  ramecek();
  setcolor(YELLOW);
  gotoxy(12,13);
  printf("%s", zprava);
  scanf("%lf", &hodnota);
  if(hodnota >= min && hodnota <= max)
			 return(hodnota);
  }
}


void ramecek(void)
{
	cleardevice();
	setcolor(BLUE);
	moveto(0, 0);
	lineto(mx ,0);
	lineto(mx, my);
	lineto(0, my);
	lineto(0, 0);
return;
}


void transformace(int x, int y, int z, int barva)
{
	double xx, yy;

	xx = y - q * x * cos(-M_PI_4);
	yy = z - q * x * sin(-M_PI_4);
	putpixel(xx + mx_2, yy + my_2, barva);

return;
}